#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <mpi.h>

#define DIMENSION_X 16
#define DIMENSION_Y 16

int main(int argc, char *argv[]) {
	int r, size, myrank, offset;

	MPI_File fh;
	MPI_Status s;

	MPI_Init(&argc, &argv);

	MPI_Comm_size(MPI_COMM_WORLD, &size);
	MPI_Comm_rank(MPI_COMM_WORLD, &myrank);

	r = MPI_File_open(MPI_COMM_WORLD, "write-c-ifp-view-subarray-datatype-double.data", MPI_MODE_CREATE|MPI_MODE_WRONLY, MPI_INFO_NULL, &fh);

	int sizes[2], subsizes[2], starts[2];
	double subarray[DIMENSION_X][DIMENSION_Y/size];

	// Dimensions of the array
	sizes[0] = DIMENSION_X;				// i (row)
	sizes[1] = DIMENSION_Y;				// j (column)

	// Dimensions of the subarray
	subsizes[0] = DIMENSION_X;			// i (row)
	subsizes[1] = DIMENSION_Y / size;		// j (column)

	// Where the subarray starts
	starts[0] = 0;					// i (row)
	starts[1] = subsizes[1] * myrank;		// j (column)

	MPI_Datatype filetype;
	MPI_Type_create_subarray(2, sizes, subsizes, starts, MPI_ORDER_C, MPI_DOUBLE, &filetype);
	MPI_Type_commit(&filetype);

	MPI_File_set_view(fh, 0, MPI_INT, filetype, "native", MPI_INFO_NULL);

	int count = 0;

	// Each process will fill its local array with the value of ('a' + rank)
	for (int i = 0; i < subsizes[0]; i++) {
		for (int j = 0; j < subsizes[1]; j++) {
			subarray[i][j] = myrank + (count++ / 100.0);
		}
	}

	// Write the subarray
	MPI_File_write_all(fh, &subarray, DIMENSION_X * DIMENSION_Y / size, MPI_DOUBLE, &s);

	// Close the file
	MPI_File_close(&fh);

	MPI_Finalize();

	return 0;
}
